/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

public class ExtensionMap {
    private int[] mapData = new int[128];

    public ExtensionMap() {
        int n = 0;
        int n2 = 0;
        while (n < this.mapData.length) {
            this.mapData[n] = 0;
            ++n;
            n2 += 2;
        }
        this.mapData[0] = 240;
    }

    public int generateChecksum() {
        int n = 0;
        for (int i = 0; i < this.mapData.length - 1; ++i) {
            n += this.mapData[i];
        }
        n &= 0xFF;
        this.mapData[this.mapData.length - 1] = n = 256 - n;
        return n;
    }

    public void setExtensionBlockTag(int n, int n2) {
        if (n >= 2) {
            this.mapData[n - 1] = n2;
        }
    }

    public int getExtensionBlockTag(int n) {
        return this.mapData[n - 1];
    }

    public void removeExtensionBlockTag(int n) {
        this.mapData[n - 1] = 0;
    }

    public void swapBlockPositions(int n, int n2) {
        int n3 = this.mapData[n2 - 1];
        this.mapData[n2 - 1] = this.mapData[n - 1];
        this.mapData[n] = n3;
    }

    public void uploadData(String string) {
        int n = 0;
        int n2 = 0;
        while (n < this.mapData.length) {
            this.mapData[n] = Integer.parseInt(string.substring(n2, n2 + 2), 16);
            ++n;
            n2 += 2;
        }
    }

    public String extractBlockData() {
        String string = new String();
        this.generateChecksum();
        for (int i = 0; i < this.mapData.length; ++i) {
            string = string.concat(String.format("%02X", this.mapData[i]));
        }
        return string;
    }
}

